#!/usr/bin/env bash
set -euo pipefail

APP_NAME="PastePilot.app"
SCRIPT_DIR="$(cd "$(dirname "$0")" && pwd)"
SOURCE_APP="${SCRIPT_DIR}/${APP_NAME}"

if [[ ! -d "${SOURCE_APP}" ]]; then
  echo "Could not find ${APP_NAME} next to this installer script."
  exit 1
fi

TARGET_DIR="/Applications"
if [[ ! -w "${TARGET_DIR}" ]]; then
  TARGET_DIR="${HOME}/Applications"
  mkdir -p "${TARGET_DIR}"
fi
TARGET_APP="${TARGET_DIR}/${APP_NAME}"

osascript -e 'tell application "PastePilot" to quit' >/dev/null 2>&1 || true

rm -rf "${TARGET_APP}"
ditto "${SOURCE_APP}" "${TARGET_APP}"
xattr -dr com.apple.quarantine "${TARGET_APP}" >/dev/null 2>&1 || true

open "${TARGET_APP}"

echo
echo "PastePilot installed to: ${TARGET_APP}"
echo "If macOS still blocks opening, run:"
echo "xattr -dr com.apple.quarantine \"${TARGET_APP}\""
